<?php 

class Whitelabel extends MY_Controller
{
    public $module_name;
	function __construct()
    {
        parent::__construct();

        $this->module_name = $this->router->fetch_module();
        $this->load->model('../extensions/'.$this->module_name.'/models/Whitelabel_ext_model');
        $this->load->library('../extensions/'.$this->module_name.'/libraries/whitelabel_email_template');
        $this->load->library('form_validation');
        $this->load->helper('language_translation');
        $this->load->helper('timezone');
        
        $view_data['menu_on']          = true;
        $this->load->vars($view_data);
    }

    // function whitelabel_partners(){       
    //     redirect('edit_whitelabel_partner/'.$partner_id);
    // }


    function edit_whitelabel_partner()
    {

        $partner_id = $this->Whitelabel_ext_model->get_partner_id($this->company_id);
        // Loading required model 
        // $this->load->model('Whitelabel_partner_model');
        $this->load->model('Currency_model');
        $this->load->model('Image_model');
        $this->load->library('email');
        
        
        // $this->load->helper('timezone');
        $data['timezones'] = get_timezones();        
        $data['available_currencies'] = $this->Currency_model->get_available_currency_list($this->company_id);

        $partner = $this->Whitelabel_ext_model->get_partner_detail($partner_id);
        
         if(!$partner['logo_image_group_id']){
            $cdata = array();
            $cdata['logo_image_group_id'] = $this->Image_model->create_image_group(VENDOR_LOGO_IMAGE_TYPE_ID);
            $image_group_id = $cdata['logo_image_group_id'];
            $this->Whitelabel_ext_model->update_whitelabel_partner($partner_id, $cdata);
        } else {
            $image_group_id = $partner['logo_image_group_id'];
        }

        if($this->input->post())
        {
            $this->form_validation->set_rules('name', 'Name', 'trim|required');
            $this->form_validation->set_rules('username', 'Username', 'trim|required');
            $this->form_validation->set_rules('time_zone', 'Timezone', 'trim|required');
            $this->form_validation->set_rules('default_currency', 'Currency', 'trim|required');
            
            if ($this->form_validation->run()) {

                $old_admin_user_id = $this->input->post('old_admin_user_id');
                $admin_user_id = $this->input->post('admin_user_id');
                $old_user_data = $this->User_model->get_user_by_email($old_admin_user_id);
                $user_data = $this->User_model->get_user_by_email($admin_user_id);
                $old_admin_user_id = $old_user_data['id'];
                $admin_user_id = $user_data['id'];
                
                if(($old_admin_user_id != $admin_user_id))
                {
                    // get company id
                    $company_ids = $this->Whitelabel_ext_model->get_partner_company_ids($partner_id);
                    if($company_ids)
                    {                        
                        foreach($company_ids as $row)
                        {
                            if($admin_user_id != 0)
                            {
                                // Adding new permissions
                                $add_permission_result = $this->Whitelabel_ext_model->add_new_permissions($admin_user_id, $row['company_id']);
                            }
                            
                        }
                    }

                    // deleting previous permissions 
                    $delete_result = $this->Whitelabel_ext_model->delete_previous_permissions($old_admin_user_id);
                }

                if($partner['domain'] != $this->input->post('domain') && $this->input->post('do_not_reply_email')!= '' || $partner['support_email'] != $this->input->post('support_email') && $this->input->post('support_email')!= '' || $partner['do_not_reply_email'] != $this->input->post('do_not_reply_email') && $this->input->post('do_not_reply_email')!= ''){

                    $email_subject = "Whitelabel Partner Settings Change Alert";
                    $data_array = array();

                    if($partner['domain'] != $this->input->post('domain')){
                        $data_array['domain'] = $this->input->post('domain');
                    } 
                    if($partner['support_email'] != $this->input->post('support_email')){
                        $data_array['support_email'] = $this->input->post('support_email');
                    }
                    if($partner['do_not_reply_email'] != $this->input->post('do_not_reply_email')){
                        $data_array['do_not_reply_email'] = $this->input->post('do_not_reply_email');
                    }

                    $result_array = $this->whitelabel_email_template->send_whitelabel_domain_email($partner,$data_array, $email_subject);
                }

                $update_data = array();
                $update_data['name'] = $this->input->post('name');
                $update_data['username'] = $this->input->post('username');
                // $update_data['admin_user_id'] = $admin_user_id;
                $update_data['domain'] = $this->input->post('domain');
                $update_data['timezone'] = $this->input->post('time_zone');
                $update_data['currency_id'] = $this->input->post('default_currency');
                $update_data['location'] = json_encode($this->input->post('location'), true);
                $update_data['privacy_policy'] = $this->input->post('privacy_policy');
                $update_data['terms_of_service'] = $this->input->post('terms_of_service');
                $update_data['domain'] = $this->input->post('domain');
                $update_data['support_email'] = $this->input->post('support_email');
                $update_data['do_not_reply_email'] = $this->input->post('do_not_reply_email');
                $update_data['overbooking_alert_email'] = $this->input->post('overbooking_alert_email');
                $update_data['show_on_partners_page'] = $this->input->post('show_on_partners_page');
                $update_data['website'] = $this->input->post('website');
                $update_data['default_property_status'] = $this->input->post('default_property_status');
                $update_data['intercom_app_id'] = $this->input->post('intercom_app_id');
                $image = $this->Image_model->get_images($image_group_id);
                
                if(isset($image[0]) && $image[0]){
                    if (substr($partner['logo'], strpos($partner['logo'], '/') + 1) !== $image[0]['filename']) {
                        $update_data['logo'] = $this->company_id."/".$image[0]['filename'];
                    }
                }
               
                $update_status = $this->Whitelabel_ext_model->update_whitelabel_partner($partner_id, $update_data);
                $wpinfo = $this->session->userdata('white_label_information');
                $wpinfo['currency_id'] =$update_data['currency_id'];
                $this->session->set_userdata('white_label_information', $wpinfo);

                $this->session->set_flashdata('success_message', 'Updated Successfully');
            }
            else
            {
                $this->session->set_flashdata('error_message', 'Please fill required Feilds');
            }            
        }

        // getting whitelabel partner detail     
        $data['partner_id'] = $partner_id;
        $data['logo_images'] = $this->Image_model->get_images($partner['logo_image_group_id']);   
        $data['partner_detail'] = $this->Whitelabel_ext_model->get_partner_detail($partner_id);
        $data['whitelabel_partner_types'] = $this->Whitelabel_ext_model->get_whitelabel_partner_types();

        $data['main_content'] = '../extensions/'.$this->module_name.'/views/edit_whitelabel_partner';
        $this->template->load('bootstrapped_template', null , $data['main_content'], $data);

    }

}